export type Clock = {
    now: number;
    timeouts: any;
    Date: any;
    loopLimit: number;
    requestIdleCallback: (func: Function, timeout: number) => any;
    cancelIdleCallback: (timerId: number) => any;
    setTimeout: (func: Function, timerId: number) => any;
    clearTimeout: (timerId: number) => any;
    nextTick: (func: Function) => any;
    queueMicrotask: (func: Function) => any;
    setInterval: (func: Function, timeout: number) => any;
    clearInterval: (timerId: number) => any;
    setImmediate: (func: Function) => any;
    clearImmediate: (timerId: number) => any;
    countTimers: () => number;
    requestAnimationFrame: (func: Function) => any;
    cancelAnimationFrame: (timerId: number) => any;
    runMicrotasks: () => void;
    tick: (tickValue: string | number) => number;
    tickAsync: (tickValue: string | number) => Promise<number>;
    next: () => number;
    nextAsync: () => Promise<number>;
    runAll: () => number;
    runToFrame: () => number;
    runAllAsync: () => Promise<number>;
    runToLast: () => number;
    runToLastAsync: () => Promise<number>;
    reset: () => void;
    setSystemTime: (systemTime: number | Date) => void;
    performance: any;
    hrTime: (prev: any) => number[];
    /**
     * Uninstall the clock.
     */
    uninstall: () => void;
    methods: any;
};
export namespace timers {
    export const setTimeout: any;
    export const clearTimeout: any;
    export const setInterval: any;
    export const clearInterval: any;
    const Date_1: any;
    export { Date_1 as Date };
}
/**
 * @param start {Date|number} the system time - non-integer values are floored
 * @param loopLimit {number}  maximum number of timers that will be run when calling runAll()
 * @returns {Clock}
 */
export function createClock(start: Date | number, loopLimit: number): Clock;
/**
 * Configuration object for the `install` method.
 *
 * @typedef {object} Config
 * @property [now] {number|Date}  a number (in milliseconds) or a Date object (default epoch)
 * @property [toFake] {string[]} names of the methods that should be faked.
 * @property [loopLimit] {number} the maximum number of timers that will be run when calling runAll()
 * @property [shouldAdvanceTime] {Boolean} tells FakeTimers to increment mocked time automatically (default false)
 * @property [advanceTimeDelta] {Number} increment mocked time every <<advanceTimeDelta>> ms (default: 20ms)
 */
/**
 * @param [config] {Config} optional config
 * @returns {Clock}
 */
export function install(config?: {
    /**
     * a number (in milliseconds) or a Date object (default epoch)
     */
    now?: number | Date;
    /**
     * names of the methods that should be faked.
     */
    toFake?: string[];
    /**
     * the maximum number of timers that will be run when calling runAll()
     */
    loopLimit?: number;
    /**
     * tells FakeTimers to increment mocked time automatically (default false)
     */
    shouldAdvanceTime?: boolean;
    /**
     * increment mocked time every <<advanceTimeDelta>> ms (default: 20ms)
     */
    advanceTimeDelta?: number;
}, ...args: any[]): Clock;
/**
 * @typedef {object} Clock
 * @property {number} now
 * @property {any} timeouts
 * @property {any} Date
 * @property {number} loopLimit
 * @property {(func: Function, timeout: number) => any} requestIdleCallback
 * @property {(timerId: number) => any} cancelIdleCallback
 * @property {(func: Function, timerId: number) => any} setTimeout
 * @property {(timerId: number) => any} clearTimeout
 * @property {(func: Function) => any} nextTick
 * @property {(func: Function) => any} queueMicrotask
 * @property {(func: Function, timeout: number) => any} setInterval
 * @property {(timerId: number) => any} clearInterval
 * @property {(func: Function) => any} setImmediate
 * @property {(timerId: number) => any} clearImmediate
 * @property {() => number} countTimers
 * @property {(func: Function) => any} requestAnimationFrame
 * @property {(timerId: number) => any} cancelAnimationFrame
 * @property {() => void} runMicrotasks
 * @property {(tickValue: string | number) => number} tick
 * @property {(tickValue: string | number) => Promise<number>} tickAsync
 * @property {() => number} next
 * @property {() => Promise<number>} nextAsync
 * @property {() => number} runAll
 * @property {() => number} runToFrame
 * @property {() => Promise<number>} runAllAsync
 * @property {() => number} runToLast
 * @property {() => Promise<number>} runToLastAsync
 * @property {() => void} reset
 * @property {(systemTime: number | Date) => void} setSystemTime
 * @property {any} performance
 * @property {(prev: any) => number[]} hrTime
 * @property {() => void} uninstall Uninstall the clock.
 * @property {any} methods
 */
export function withGlobal(_global: any): {
    timers: {
        setTimeout: any;
        clearTimeout: any;
        setInterval: any;
        clearInterval: any;
        Date: any;
    };
    createClock: (start: Date | number, loopLimit: number) => Clock;
    install: (config?: {
        /**
         * a number (in milliseconds) or a Date object (default epoch)
         */
        now?: number | Date;
        /**
         * names of the methods that should be faked.
         */
        toFake?: string[];
        /**
         * the maximum number of timers that will be run when calling runAll()
         */
        loopLimit?: number;
        /**
         * tells FakeTimers to increment mocked time automatically (default false)
         */
        shouldAdvanceTime?: boolean;
        /**
         * increment mocked time every <<advanceTimeDelta>> ms (default: 20ms)
         */
        advanceTimeDelta?: number;
    }, ...args: any[]) => Clock;
    withGlobal: typeof withGlobal;
};
