'use strict'

var ip = require('ip-regex')

var port = '(?::+(\\d+))?'
var v4 = '(' + ip.v4().source + ')' + port
var v6 = '\\[(' + ip.v6().source + ')\\]' + port + '|(' + ip.v6().source + ')'

var ip = module.exports = function (opts) {
  opts = opts || {}
  return opts.exact ? new RegExp('(?:^' + v4 + '$)|(?:^' + v6 + '$)') :
    new RegExp('(?:' + v4 + ')|(?:' + v6 + ')', 'g')
}

ip.v4 = function (opts) {
  opts = opts || {}
  return opts.exact ? new RegExp('^' + v4 + '$') : new RegExp(v4, 'g')
}

ip.v6 = function (opts) {
  opts = opts || {}
  return opts.exact ? new RegExp('^' + v6 + '$') : new RegExp(v6, 'g')
}

ip.parts = function (str) {
  var parts = new RegExp(v6 + '|' + v4, 'g').exec(str)

  return {
    ip: parts === null ? null : parts[1] || parts[3] || parts[4] || null,
    port: parts === null ? null : parts[2] || parts[5] || null
  }
}
