let _objectSpread;
module.link("@babel/runtime/helpers/objectSpread2", {
  default(v) {
    _objectSpread = v;
  }
}, 0);
module.export({
  JsFile: () => JsFile,
  CssFile: () => CssFile
});
let buildmessage;
module.link("../utils/buildmessage.js", {
  default(v) {
    buildmessage = v;
  }
}, 0);
let optimisticReadFile, optimisticHashOrNull;
module.link("../fs/optimistic", {
  optimisticReadFile(v) {
    optimisticReadFile = v;
  },
  optimisticHashOrNull(v) {
    optimisticHashOrNull = v;
  }
}, 1);
let convertToPosixPath;
module.link("../fs/files", {
  convertToPosixPath(v) {
    convertToPosixPath = v;
  }
}, 2);
const buildPluginModule = require('./build-plugin.js');
class InputFile extends buildPluginModule.InputFile {
  constructor(source) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    super();
    this._source = source;
    this._arch = options.arch;
    this._watchSet = options.watchSet;
    this._minifiedFiles = [];
  }
  getContentsAsBuffer() {
    return this._source.contents();
  }
  getPathInPackage() {
    throw new Error("Compiled files don't belong to any package");
  }
  getPackageName() {
    throw new Error("Compiled files don't belong to any package");
  }
  getSourceHash() {
    return this._source.hash();
  }
  getArch() {
    return this._arch;
  }
  getSourcePath() {
    return this._source.sourcePath || null;
  }
  error(_ref) {
    let {
      message,
      sourcePath,
      line,
      column,
      func
    } = _ref;
    const relPath = this.getPathInBundle();
    buildmessage.error(message || 'error minifying ' + relPath, {
      file: sourcePath || relPath,
      line: line ? line : undefined,
      column: column ? column : undefined,
      func: func ? func : undefined
    });
  }

  /**
   * @summary Returns the path of the compiled file in the bundle.
   * @memberof InputFile
   * @returns {String}
   */
  getPathInBundle() {
    return this._source.targetPath;
  }

  /**
   * @summary Returns the source-map associated with the file.
   * @memberof InputFile
   * @returns {String}
   */
  getSourceMap() {
    return this._source.sourceMap;
  }
}
class JsFile extends InputFile {
  // - data
  // - sourceMap
  // - path
  // - hash?
  // - stats?
  addJavaScript(options) {
    this._minifiedFiles.push(_objectSpread({}, options));
  }
}
class CssFile extends InputFile {
  // - data
  // - sourceMap
  // - path
  // - hash?
  // - stats?
  addStylesheet(options) {
    this._minifiedFiles.push(_objectSpread({}, options));
  }
  readAndWatchFileWithHash(path) {
    const filePath = convertToPosixPath(path);
    const hash = optimisticHashOrNull(filePath);
    const contents = optimisticReadFile(filePath);
    this._watchSet.addFile(filePath, hash);
    return {
      hash,
      contents
    };
  }
}
//# sourceMappingURL=minifier-plugin.js.map