module.export({
  randomString: () => randomString,
  accountsCommandTimeoutSecs: () => accountsCommandTimeoutSecs,
  randomAppName: () => randomAppName,
  randomUserEmail: () => randomUserEmail,
  login: () => login,
  logout: () => logout,
  registrationUrlRegexp: () => registrationUrlRegexp,
  randomOrgName: () => randomOrgName,
  createOrganization: () => createOrganization,
  getMeteorRuntimeConfigFromHTML: () => getMeteorRuntimeConfigFromHTML,
  checkForSettings: () => checkForSettings,
  markThrowingMethods: () => markThrowingMethods,
  getPrivateIPAddress: () => getPrivateIPAddress
});
let getAuthDDPUrl;
module.link("../meteor-services/config.js", {
  getAuthDDPUrl(v) {
    getAuthDDPUrl = v;
  }
}, 0);
let timeoutScaleFactor;
module.link("../utils/utils.js", {
  timeoutScaleFactor(v) {
    timeoutScaleFactor = v;
  }
}, 1);
let withAccountsConnection;
module.link("../meteor-services/auth.js", {
  withAccountsConnection(v) {
    withAccountsConnection = v;
  }
}, 2);
let fail, markStack;
module.link("./selftest.js", {
  fail(v) {
    fail = v;
  },
  markStack(v) {
    markStack = v;
  }
}, 3);
let request;
module.link("../utils/http-helpers.js", {
  request(v) {
    request = v;
  }
}, 4);
let loadIsopackage;
module.link("../tool-env/isopackets.js", {
  loadIsopackage(v) {
    loadIsopackage = v;
  }
}, 5);
let networkInterfaces;
module.link("os", {
  networkInterfaces(v) {
    networkInterfaces = v;
  }
}, 6);
function randomString(charsCount) {
  var chars = 'abcdefghijklmnopqrstuvwxyz';
  var str = '';
  for (var i = 0; i < charsCount; i++) {
    str = str + chars.charAt(Math.floor(Math.random() * chars.length));
  }
  return str;
}
const accountsCommandTimeoutSecs = 15 * timeoutScaleFactor;
function randomAppName() {
  return 'selftest-app-' + randomString(10);
}
function randomUserEmail() {
  return 'selftest-user-' + randomString(15) + '@guerrillamail.com';
}
async function login(s, username, password) {
  var run = s.run('login');
  run.waitSecs(15);
  await run.matchErr('Username:');
  run.write(username + '\n');
  await run.matchErr('Password:');
  run.write(password + '\n');
  run.waitSecs(15);
  await run.matchErr('Logged in as ' + username + ".");
  await run.expectExit(0);
}
async function logout(s) {
  var run = s.run('logout');
  run.waitSecs(15);
  await run.matchErr('Logged out');
  await run.expectExit(0);
}
const registrationUrlRegexp = /https:\/\/www\.meteor\.com\/setPassword\?([a-zA-Z0-9\+\/]+)/;
function randomOrgName() {
  return "selftestorg" + exports.randomString(10);
}
function createOrganization(username, password) {
  var orgName = exports.randomOrgName();
  withAccountsConnection(function (conn) {
    try {
      conn.call("login", {
        meteorAccountsLoginInfo: {
          username: username,
          password: password
        },
        clientInfo: {}
      });
    } catch (err) {
      fail("Failed to log in to Meteor developer accounts\n" + "with test user: " + err);
    }
    try {
      conn.call("createOrganization", orgName);
    } catch (err) {
      fail("Failed to create organization: " + err);
    }
  })();
  return orgName;
}
function getMeteorRuntimeConfigFromHTML(html) {
  var m = html.match(/__meteor_runtime_config__ = JSON.parse\(decodeURIComponent\("([^"]+?)"\)\)/);
  if (!m) {
    fail("Can't find __meteor_runtime_config__");
  }
  return JSON.parse(decodeURIComponent(m[1]));
}
const checkForSettings = markStack(async function (appName, settings, timeoutSecs) {
  var timeoutDate = new Date(new Date().valueOf() + timeoutSecs * 1000);
  while (true) {
    if (new Date() >= timeoutDate) {
      fail('Expected settings not found on app ' + appName);
    }
    var result = await request('http://' + appName);

    // XXX This is brittle; the test will break if we start formatting the
    // __meteor_runtime_config__ JS differently. Ideally we'd do something
    // like point a phantom at the deployed app and actually evaluate
    // Meteor.settings.
    try {
      var mrc = exports.getMeteorRuntimeConfigFromHTML(result.body);
    } catch (e) {
      // ignore
      continue;
    }
    if (_.isEqual(mrc.PUBLIC_SETTINGS, settings['public'])) {
      return;
    }
  }
});
function markThrowingMethods(prototype) {
  Object.keys(prototype).forEach(key => {
    const value = prototype[key];
    if (typeof value === "function") {
      const code = Function.prototype.toString.call(value);
      if (/\bnew TestFailure\b/.test(code)) {
        prototype[name] = markStack(value);
      }
    }
  });
}
function getPrivateIPAddress() {
  const nets = networkInterfaces();
  let localIp = "";
  Object.keys(nets).some(name => {
    let ret = false;
    for (const net of nets[name]) {
      // Skip over non-IPv4, bridge and internal (i.e. 127.0.0.1) addresses
      // 'IPv4' is in Node <= 17, from 18 it's a number 4 or 6
      const familyV4Value = typeof net.family === 'string' ? 'IPv4' : 4;
      if (net.family === familyV4Value && !net.internal && !name.startsWith('br')) {
        localIp = net.address;
        ret = true;
        break;
      }
    }
    return ret;
  });
  return localIp;
}
//# sourceMappingURL=test-utils.js.map