Package["core-runtime"].queue("minifyStdCSS",function () {/* Imports */
var CssTools = Package['minifier-css'].CssTools;
var ECMAScript = Package.ecmascript.ECMAScript;
var Log = Package.logging.Log;
var meteorInstall = Package.modules.meteorInstall;
var Promise = Package.promise.Promise;

var require = meteorInstall({"node_modules":{"meteor":{"minifyStdCSS":{"plugin":{"minify-css.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/minifyStdCSS/plugin/minify-css.js                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let sourcemap;
    module.link("source-map", {
      default(v) {
        sourcemap = v;
      }
    }, 0);
    let createHash;
    module.link("crypto", {
      createHash(v) {
        createHash = v;
      }
    }, 1);
    let LRUCache;
    module.link("lru-cache", {
      default(v) {
        LRUCache = v;
      }
    }, 2);
    let loadPostCss, watchAndHashDeps, usePostCss;
    module.link("./postcss.js", {
      loadPostCss(v) {
        loadPostCss = v;
      },
      watchAndHashDeps(v) {
        watchAndHashDeps = v;
      },
      usePostCss(v) {
        usePostCss = v;
      }
    }, 3);
    let Log;
    module.link("meteor/logging", {
      Log(v) {
        Log = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const {
      argv,
      env: {
        DEBUG_CSS
      }
    } = process;
    const verbose = DEBUG_CSS !== "false" && DEBUG_CSS !== "0" && (DEBUG_CSS || argv.indexOf('--verbose') > -1 || argv.indexOf('--debug') > -1);
    Plugin.registerMinifier({
      extensions: ["css"],
      archMatching: "web"
    }, function () {
      const minifier = new CssToolsMinifier();
      return minifier;
    });
    class CssToolsMinifier {
      constructor() {
        this.cache = new LRUCache({
          max: 100
        });
        this.depsHashCache = Object.create(null);
        this.totalSize = 0;
        this.totalMinifiedSize = 0;
        this.haveHitAnyCache = false; // once we hit the cache, there's no point in showing 'Adding CSS', we know it will be fine and floods the terminal needlessly.
      }
      beforeMinify() {
        this.depsHashCache = Object.create(null);
      }
      formatSize(bytes) {
        return bytes < 1024 ? "".concat(bytes, " bytes") : "".concat(Math.round(bytes / 1024), "k");
      }
      watchAndHashDeps(deps, file) {
        const cacheKey = JSON.stringify(deps);
        if (cacheKey in this.depsHashCache) {
          return this.depsHashCache[cacheKey];
        }
        let hash = watchAndHashDeps(deps, filePath => {
          return file.readAndWatchFileWithHash(filePath).hash;
        });
        this.depsHashCache[cacheKey] = hash;
        return hash;
      }
      async minifyFiles(files, mode, postcssConfig) {
        const cacheKey = createCacheKey(files, mode);
        const cachedResult = this.cache.get(cacheKey);
        if (cachedResult && cachedResult.depsCacheKey === this.watchAndHashDeps(cachedResult.deps, files[0])) {
          if (verbose && !this.haveHitAnyCache) {
            this.haveHitAnyCache = true;
            setTimeout(() => {
              // we use a timeout to give all files a chance to finish being minified
              const stats = ["minifyStdCSS: Total CSS ".concat(this.formatSize(this.totalSize))];
              if (this.totalMinifiedSize !== 0) {
                stats.push("minified ".concat(this.formatSize(this.totalMinifiedSize)));
                stats.push("reduction ".concat(Math.round(100 - this.totalMinifiedSize * 100 / this.totalSize), "%"));
              }
              console.log(stats.join(", "));
            }, 500);
          }
          return cachedResult.stylesheets;
        }
        let result = [];
        if (verbose) process.stdout.write(" > Merging [ ".concat(files.map(_ref => {
          let {
            _source: {
              targetPath
            }
          } = _ref;
          return targetPath;
        }).join(' '), " ]"));
        const merged = await mergeCss(files, postcssConfig);
        if (verbose) {
          process.stdout.write(" > ".concat(this.formatSize(merged.code.length)));
          this.totalSize += merged.code.length;
        }
        if (mode === 'development') {
          result = [{
            data: merged.code,
            sourceMap: merged.sourceMap,
            path: 'merged-stylesheets.css'
          }];
        } else {
          if (verbose) process.stdout.write(" > minifying");
          const minifiedFiles = await CssTools.minifyCssAsync(merged.code);
          result = minifiedFiles.map(minified => ({
            data: minified
          }));
          if (verbose) {
            const minifiedSize = minifiedFiles.reduce((sum, minifiedFile) => sum + minifiedFile.length, 0);
            process.stdout.write(" > ".concat(this.formatSize(minifiedSize)));
            this.totalMinifiedSize += minifiedSize;
          }
        }
        if (verbose) process.stdout.write('\n');
        this.cache.set(cacheKey, {
          stylesheets: result,
          deps: merged.deps,
          depsCacheKey: this.watchAndHashDeps(merged.deps, files[0])
        });
        return result;
      }
      async processFilesForBundle(files, _ref2) {
        let {
          minifyMode
        } = _ref2;
        if (!files.length) return;
        const {
          error,
          postcssConfig
        } = await loadPostCss();
        if (error) {
          if (verbose) Log.error('processFilesForBundle loadPostCss error', error);
          files[0].error(error);
          return;
        }
        const stylesheets = await this.minifyFiles(files, minifyMode, postcssConfig);
        stylesheets.forEach((stylesheet, i) => {
          if (verbose && !this.haveHitAnyCache) process.stdout.write("Adding CSS".concat(i === 0 ? '' : ' ' + i + 1));
          files[0].addStylesheet(stylesheet);
        });
      }
    }
    const createCacheKey = Profile("createCacheKey", function (files, minifyMode) {
      const hash = createHash("sha1");
      hash.update(minifyMode).update("\0");
      files.forEach(f => {
        hash.update(f.getSourceHash()).update("\0");
      });
      return hash.digest("hex");
    });
    function disableSourceMappingURLs(css) {
      return css.replace(/# sourceMappingURL=/g, "# sourceMappingURL_DISABLED=");
    }

    // Lints CSS files and merges them into one file, fixing up source maps and
    // pulling any @import directives up to the top since the CSS spec does not
    // allow them to appear in the middle of a file.
    const mergeCss = Profile("mergeCss", async function (css, postcssConfig) {
      // Filenames passed to AST manipulator mapped to their original files
      const originals = {};
      const deps = [];
      const astPromises = css.map(async function (file) {
        const filename = file.getPathInBundle();
        originals[filename] = file;
        let ast;
        try {
          let content = disableSourceMappingURLs(file.getContentsAsString());
          if (usePostCss(file, postcssConfig)) {
            const result = await postcssConfig.postcss(postcssConfig.plugins).process(content, {
              from: Plugin.convertToOSPath(file.getSourcePath()),
              parser: postcssConfig.options.parser
            });
            result.warnings().forEach(warning => {
              warnCb(filename, warning.toString());
            });
            result.messages.forEach(message => {
              if (['dependency', 'dir-dependency'].includes(message.type)) {
                deps.push(message);
              }
            });
            content = result.css;
          }
          const parseOptions = {
            source: filename,
            position: true
          };
          ast = CssTools.parseCss(content, parseOptions);
          ast.filename = filename;
        } catch (e) {
          if (e.reason) {
            file.error({
              message: e.reason,
              line: e.line,
              column: e.column
            });
          } else {
            // Just in case it's not the normal error the library makes.
            file.error({
              message: e.stack
            });
          }
          return {
            type: "stylesheet",
            stylesheet: {
              rules: []
            },
            filename
          };
        }
        return ast;
      });
      const cssAsts = await Promise.all(astPromises);
      const mergedCssAst = CssTools.mergeCssAsts(cssAsts, warnCb);

      // Overwrite the CSS files list with the new concatenated file
      const stringifiedCss = CssTools.stringifyCss(mergedCssAst, {
        sourcemap: true,
        // don't try to read the referenced sourcemaps from the input
        inputSourcemaps: false
      });
      if (!stringifiedCss.code) {
        return {
          code: '',
          deps
        };
      }

      // Add the contents of the input files to the source map of the new file
      stringifiedCss.map.sourcesContent = stringifiedCss.map.sources.map(function (filename) {
        const file = originals[filename] || null;
        return file && file.getContentsAsString();
      });

      // Compose the concatenated file's source map with source maps from the
      // previous build step if necessary.
      const newMap = await Profile.time("composing source maps", async function () {
        const newMap = new sourcemap.SourceMapGenerator();
        const concatConsumer = await new sourcemap.SourceMapConsumer(stringifiedCss.map);
        // Create a dictionary of source map consumers for fast access
        const consumers = Object.create(null);
        await Promise.all(Object.entries(originals).map(async _ref3 => {
          let [name, file] = _ref3;
          const sourceMap = file.getSourceMap();
          if (sourceMap) {
            try {
              consumers[name] = await new sourcemap.SourceMapConsumer(sourceMap);
            } catch (err) {
              // If we can't apply the source map, silently drop it.
              //
              // XXX This is here because there are some less files that
              // produce source maps that throw when consumed. We should
              // figure out exactly why and fix it, but this will do for now.
            }
          }
        }));

        // Maps each original source file name to the SourceMapConsumer that
        // can provide its content.
        const sourceToConsumerMap = Object.create(null);

        // Find mappings from the concatenated file back to the original files
        concatConsumer.eachMapping(mapping => {
          let {
            source
          } = mapping;
          const consumer = consumers[source];
          let original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };

          // If there is a source map for the original file, e.g., if it has been
          // compiled from Less to CSS, find the source location in the original's
          // original file. Otherwise, use the mapping of the concatenated file's
          // source map.
          if (consumer) {
            const newOriginal = consumer.originalPositionFor(original);

            // Finding the original position should always be possible (otherwise,
            // one of the source maps would have incorrect mappings). However, in
            // case there is something wrong, use the intermediate mapping.
            if (newOriginal.source !== null) {
              original = newOriginal;
              source = original.source;
              if (source) {
                // Since the new consumer provided a different
                // original.source, we should ask it for the original source
                // content instead of asking the concatConsumer.
                sourceToConsumerMap[source] = consumer;
              }
            }
          }
          if (source && !sourceToConsumerMap[source]) {
            // If we didn't set sourceToConsumerMap[source] = consumer above,
            // use the concatConsumer to determine the original content.
            sourceToConsumerMap[source] = concatConsumer;
          }

          // Add a new mapping to the final source map
          newMap.addMapping({
            generated: {
              line: mapping.generatedLine,
              column: mapping.generatedColumn
            },
            original,
            source
          });
        });

        // The consumer.sourceContentFor and newMap.setSourceContent methods
        // are relatively fast, but not entirely trivial, so it's better to
        // call them only once per source, rather than calling them every time
        // we call newMap.addMapping in the loop above.
        Object.entries(sourceToConsumerMap).forEach(_ref4 => {
          let [source, consumer] = _ref4;
          const content = consumer.sourceContentFor(source);
          newMap.setSourceContent(source, content);
        });
        concatConsumer.destroy();
        Object.values(consumers).forEach(consumer => consumer.destroy());
        return newMap;
      });
      return {
        code: stringifiedCss.code,
        sourceMap: newMap.toString(),
        deps
      };
    });
    function warnCb(filename, msg) {
      // XXX make this a buildmessage.warning call rather than a random log.
      //     this API would be like buildmessage.error, but wouldn't cause
      //     the build to fail.
      Log.warn("".concat(filename, ": warn: ").concat(msg));
    }
    ;
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"postcss.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// node_modules/meteor/minifyStdCSS/plugin/postcss.js                                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.export({loadPostCss:()=>loadPostCss,usePostCss:()=>usePostCss});module.export({watchAndHashDeps:()=>watchAndHashDeps},true);let createHash;module.link("crypto",{createHash(v){createHash=v}},0);let micromatch;module.link('micromatch',{default(v){micromatch=v}},1);let performance;module.link('perf_hooks',{performance(v){performance=v}},2);



var fs = Plugin.fs;
var path = Plugin.path;

const DEBUG_CACHE = process.env.DEBUG_METEOR_POSTCSS_DEP_CACHE === 'true';

let postcssConfig;
let loaded = false;

const missingPostCssError = new Error([
    '',
    `The postcss npm package could not be found in your node_modules`,
    'directory. Please run the following command to install it:',
    '    meteor npm install postcss@8',
    'or disable postcss by removing the postcss config.',
    '',
  ].join('\n'));

async function loadPostCss() {
  if (loaded) {
    return { postcssConfig };
  }

  let loadConfig;
  try {
    loadConfig = require('postcss-load-config');
  } catch (e) {
    // The app doesn't have this package installed
    // Assuming the app doesn't use PostCSS
    loaded = true;

    return {};
 }

  let config;
  try {
    config = await loadConfig({ meteor: true });
  } catch (e) {
    if (e.message.includes('No PostCSS Config found in')) {
      // PostCSS is not used by this app
      loaded = true;

      return {};
    }

    if (e.message.includes('Cannot find module \'postcss\'')) {
      return { error: missingPostCssError };
    }

    e.message = `While loading postcss config: ${e.message}`;
    return {
      error: e,
    };
  }

  let postcss;
  try {
    postcss = require('postcss');
  } catch (e) {
    return { error: missingPostCssError };
  }

  const postcssVersion = require('postcss/package.json').version;
  const major = parseInt(postcssVersion.split('.')[0], 10);
  if (major !== 8) {
    // TODO: should this just be a warning instead?
    const error = new Error([
      '',
      `Found version ${postcssVersion} of postcss in your node_modules`,
      'directory. standard-minifier-css is only compatible with',
      'version 8 of PostCSS. Please restart Meteor after installing',
      'a supported version of PostCSS',
      '',
    ].join('\n'));

    return { error };
  }

  loaded = true;
  config.postcss = postcss;
  postcssConfig = config;

  return { postcssConfig };
}

function usePostCss(file, postcssConfig) {
  if (!postcssConfig) {
    return false;
  }

  const excludedPackages = postcssConfig.options.excludedMeteorPackages || [];
  const path = file.getPathInBundle();

  const excluded = excludedPackages.some(name => {
    return path.includes(`packages/${name.replace(':', '_')}`);
  });

  return !excluded;
}

const watchAndHashDeps = Profile(
  'watchAndHashDeps',
  function (deps, hashAndWatchFile) {
    const hash = createHash('sha1');
    const globsByDir = Object.create(null);
    let fileCount = 0;
    let folderCount = 0;
    let start = performance.now();

    deps.forEach(dep => {
      if (dep.type === 'dependency') {
        fileCount += 1;
        const fileHash = hashAndWatchFile(dep.file);
        hash.update(fileHash).update('\0');
      } else if (dep.type === 'dir-dependency') {
        if (dep.dir in globsByDir) {
          globsByDir[dep.dir].push(dep.glob || '**');
        } else {
          globsByDir[dep.dir] = [dep.glob || '**'];
        }
      }
    });


    Object.entries(globsByDir).forEach(([parentDir, globs]) => {
      const matchers = globs.map(glob => micromatch.matcher(glob));

      function walk(relDir) {
        const absDir = path.join(parentDir, relDir);
        hash.update(absDir).update('\0');
        folderCount += 1;

        const entries = fs.readdirWithTypesSync(absDir);
        for (const entry of entries) {
          const relPath = path.join(relDir, entry.name);

          if (entry.isFile() && matchers.some(isMatch => isMatch(relPath))) {
            const absPath = path.join(absDir, entry.name);
            fileCount += 1;
            hash.update(hashAndWatchFile(absPath)).update('\0');
          } else if (
            entry.isDirectory() && entry.name !== 'node_modules' && entry.name !== '.meteor'
          ) {
            walk(relPath);
          }
        }
      }

      walk('./');
    });

    let digest = hash.digest('hex');

    if (DEBUG_CACHE) {
      console.log('--- PostCSS Cache Info ---');
      console.log('Glob deps', JSON.stringify(globsByDir, null, 2));
      console.log('File dep count', fileCount);
      console.log('Walked folders', folderCount);
      console.log('Created dep cache key in', performance.now() - start, 'ms');
      console.log('--------------------------');
    }

    return digest;
});

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"node_modules":{"source-map":{"package.json":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// node_modules/meteor/minifyStdCSS/node_modules/source-map/package.json                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.exports = {
  "name": "source-map",
  "version": "0.7.4",
  "main": "./source-map.js"
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"source-map.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// node_modules/meteor/minifyStdCSS/node_modules/source-map/source-map.js                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.useNode();
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"lru-cache":{"package.json":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// node_modules/meteor/minifyStdCSS/node_modules/lru-cache/package.json                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.exports = {
  "name": "lru-cache",
  "version": "6.0.0",
  "main": "index.js"
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// node_modules/meteor/minifyStdCSS/node_modules/lru-cache/index.js                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.useNode();
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"micromatch":{"package.json":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// node_modules/meteor/minifyStdCSS/node_modules/micromatch/package.json                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.exports = {
  "name": "micromatch",
  "version": "4.0.5",
  "main": "index.js"
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// node_modules/meteor/minifyStdCSS/node_modules/micromatch/index.js                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.useNode();
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}}}}}},{
  "extensions": [
    ".js",
    ".json"
  ]
});


/* Exports */
return {
  require: require,
  eagerModulePaths: [
    "/node_modules/meteor/minifyStdCSS/plugin/minify-css.js"
  ]
}});




//# sourceURL=meteor://💻app/packages/minifyStdCSS_plugin.js
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
