Package["core-runtime"].queue("minifier-js",function () {/* Imports */
var Meteor = Package.meteor.Meteor;
var global = Package.meteor.global;
var meteorEnv = Package.meteor.meteorEnv;
var EmitterPromise = Package.meteor.EmitterPromise;
var ECMAScript = Package.ecmascript.ECMAScript;
var Babel = Package['babel-compiler'].Babel;
var BabelCompiler = Package['babel-compiler'].BabelCompiler;
var meteorInstall = Package.modules.meteorInstall;
var Promise = Package.promise.Promise;

/* Package-scope variables */
var meteorJsMinify;

var require = meteorInstall({"node_modules":{"meteor":{"minifier-js":{"minifier.js":function module(require,exports,module){

//////////////////////////////////////////////////////////////////////////////////////////
//                                                                                      //
// packages/minifier-js/minifier.js                                                     //
//                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////
                                                                                        //
module.export({
  meteorJsMinify: () => meteorJsMinify
});
let terser;
const terserMinify = async (source, options) => {
  terser = terser || Npm.require("terser");
  return await terser.minify(source, options);
};
const meteorJsMinify = async function (source) {
  const result = {};
  const NODE_ENV = process.env.NODE_ENV || "development";
  const options = {
    compress: {
      drop_debugger: false,
      // remove debugger; statements
      unused: false,
      // drop unreferenced functions and variables
      dead_code: true,
      // remove unreachable code
      typeofs: false,
      // set to false due to known issues in IE10
      global_defs: {
        "process.env.NODE_ENV": NODE_ENV
      }
    },
    // Fix issue #9866, as explained in this comment:
    // https://github.com/mishoo/UglifyJS2/issues/1753#issuecomment-324814782
    // And fix terser issue #117: https://github.com/terser-js/terser/issues/117
    safari10: true // set this option to true to work around the Safari 10/11 await bug
  };
  const terserResult = await terserMinify(source, options);

  // this is kept to maintain backwards compatability
  result.code = terserResult.code;
  result.minifier = 'terser';
  return result;
};
//////////////////////////////////////////////////////////////////////////////////////////

}}}}},{
  "extensions": [
    ".js",
    ".json"
  ]
});


/* Exports */
return {
  export: function () { return {
      meteorJsMinify: meteorJsMinify
    };},
  require: require,
  eagerModulePaths: [
    "/node_modules/meteor/minifier-js/minifier.js"
  ],
  mainModulePath: "/node_modules/meteor/minifier-js/minifier.js"
}});




//# sourceURL=meteor://💻app/packages/minifier-js.js
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
