Package["core-runtime"].queue("minifyStdJS",function () {/* Imports */
var meteorJsMinify = Package['minifier-js'].meteorJsMinify;
var ECMAScript = Package.ecmascript.ECMAScript;
var meteorInstall = Package.modules.meteorInstall;
var Promise = Package.promise.Promise;

/* Package-scope variables */
var file;

var require = meteorInstall({"node_modules":{"meteor":{"minifyStdJS":{"plugin":{"minify-js.js":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                       //
// packages/minifyStdJS/plugin/minify-js.js                                                              //
//                                                                                                       //
///////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                         //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 0);
    let extractModuleSizesTree;
    module.link("./stats.js", {
      extractModuleSizesTree(v) {
        extractModuleSizesTree = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Plugin.registerMinifier({
      extensions: ['js'],
      archMatching: 'web'
    }, () => new MeteorMinifier());
    class MeteorMinifier {
      async processFilesForBundle(files, options) {
        const mode = options.minifyMode;

        // don't minify anything for development
        if (mode === 'development') {
          files.forEach(function (file) {
            file.addJavaScript({
              data: file.getContentsAsBuffer(),
              sourceMap: file.getSourceMap(),
              path: file.getPathInBundle()
            });
          });
          return;
        }

        // this function tries its best to locate the original source file
        // that the error being reported was located inside of
        function maybeThrowMinifyErrorBySourceFile(error, file) {
          const lines = file.getContentsAsString().split(/\n/);
          const lineContent = lines[error.line - 1];
          let originalSourceFileLineNumber = 0;

          // Count backward from the failed line to find the oringal filename
          for (let i = error.line - 1; i >= 0; i--) {
            let currentLine = lines[i];

            // If the line is a boatload of slashes (8 or more), we're in the right place.
            if (/^\/\/\/{6,}$/.test(currentLine)) {
              // If 4 lines back is the same exact line, we've found the framing.
              if (lines[i - 4] === currentLine) {
                // So in that case, 2 lines back is the file path.
                let originalFilePath = lines[i - 2].substring(3).replace(/\s+\/\//, "");
                throw new Error("terser minification error (".concat(error.name, ":").concat(error.message, ")\n") + "Source file: ".concat(originalFilePath, "  (").concat(originalSourceFileLineNumber, ":").concat(error.col, ")\n") + "Line content: ".concat(lineContent, "\n"));
              }
            }
            originalSourceFileLineNumber++;
          }
        }

        // this object will collect all the minified code in the
        // data field and post-minfiication file sizes in the stats field
        const toBeAdded = {
          data: "",
          stats: Object.create(null)
        };
        var _iteratorAbruptCompletion = false;
        var _didIteratorError = false;
        var _iteratorError;
        try {
          for (var _iterator = _asyncIterator(files), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
            file = _step.value;
            {
              // Don't reminify *.min.js.
              if (/\.min\.js$/.test(file.getPathInBundle())) {
                toBeAdded.data += file.getContentsAsString();
              } else {
                let minified;
                try {
                  minified = await meteorJsMinify(file.getContentsAsString());
                } catch (err) {
                  maybeThrowMinifyErrorBySourceFile(err, file);
                  throw new Error("terser minification error (".concat(err.name, ":").concat(err.message, ")\n") + "Bundled file: ".concat(file.getPathInBundle(), "  (").concat(err.line, ":").concat(err.col, ")\n"));
                }
                const ast = extractModuleSizesTree(minified.code);
                if (ast) {
                  toBeAdded.stats[file.getPathInBundle()] = [Buffer.byteLength(minified.code), ast];
                } else {
                  toBeAdded.stats[file.getPathInBundle()] = Buffer.byteLength(minified.code);
                }
                // append the minified code to the "running sum"
                // of code being minified
                toBeAdded.data += minified.code;
              }
              toBeAdded.data += '\n\n';
              Plugin.nudge();
            }
          }

          // this is where the minified code gets added to one
          // JS file that is delivered to the client
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion && _iterator.return != null) {
              await _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
        if (files.length) {
          files[0].addJavaScript(toBeAdded);
        }
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
///////////////////////////////////////////////////////////////////////////////////////////////////////////

},"stats.js":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                       //
// packages/minifyStdJS/plugin/stats.js                                                                  //
//                                                                                                       //
///////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                         //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      extractModuleSizesTree: () => extractModuleSizesTree
    });
    let Visitor;
    module.link("@meteorjs/reify/lib/visitor.js", {
      default(v) {
        Visitor = v;
      }
    }, 0);
    let findPossibleIndexes;
    module.link("@meteorjs/reify/lib/utils.js", {
      findPossibleIndexes(v) {
        findPossibleIndexes = v;
      }
    }, 1);
    let Babel;
    module.link("meteor/babel-compiler", {
      Babel(v) {
        Babel = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    // This RegExp will be used to scan the source for calls to meteorInstall,
    // taking into consideration that the function name may have been mangled
    // to something other than "meteorInstall" by the minifier.
    const meteorInstallRegExp = new RegExp([
    // If meteorInstall is called by its unminified name, then that's what
    // we should be looking for in the AST.
    /\b(meteorInstall)\(\{/,
    // If the meteorInstall function name has been minified, we can figure
    // out its mangled name by examining the import assignment.
    /\b(\w+)=Package\.modules\.meteorInstall\b/, /\b(\w+)=Package\["modules-runtime"\].meteorInstall\b/,
    // Sometimes uglify-es will inline (0,Package.modules.meteorInstall) as
    // a call expression.
    /\(0,Package\.modules\.(meteorInstall)\)\(/, /\(0,Package\["modules-runtime"\]\.(meteorInstall)\)\(/].map(exp => exp.source).join("|"));
    function extractModuleSizesTree(source) {
      const match = meteorInstallRegExp.exec(source);
      if (match) {
        const ast = Babel.parse(source);
        let meteorInstallName = "meteorInstall";
        // The minifier may have renamed meteorInstall to something shorter.
        match.some((name, i) => i > 0 && (meteorInstallName = name));
        meteorInstallVisitor.visit(ast, meteorInstallName, source);
        return meteorInstallVisitor.tree;
      }
    }
    const meteorInstallVisitor = new class extends Visitor {
      reset(root, meteorInstallName, source) {
        this.name = meteorInstallName;
        this.source = source;
        this.tree = Object.create(null);
        // Optimization to abandon entire subtrees of the AST that contain
        // nothing like the meteorInstall identifier we're looking for.
        this.possibleIndexes = findPossibleIndexes(source, [meteorInstallName]);
      }
      visitCallExpression(path) {
        const node = path.getValue();
        if (hasIdWithName(node.callee, this.name)) {
          const source = this.source;
          function walk(tree, expr) {
            if (expr.type !== "ObjectExpression") {
              return Buffer.byteLength(source.slice(expr.start, expr.end));
            }
            tree = tree || Object.create(null);
            expr.properties.forEach(prop => {
              const keyName = getKeyName(prop.key);
              if (typeof keyName === "string") {
                tree[keyName] = walk(tree[keyName], prop.value);
              }
            });
            return tree;
          }
          walk(this.tree, node.arguments[0]);
        } else {
          this.visitChildren(path);
        }
      }
    }();
    function hasIdWithName(node, name) {
      switch (node && node.type) {
        case "SequenceExpression":
          const last = node.expressions[node.expressions.length - 1];
          return hasIdWithName(last, name);
        case "MemberExpression":
          return hasIdWithName(node.property, name);
        case "Identifier":
          return node.name === name;
        default:
          return false;
      }
    }
    function getKeyName(key) {
      if (key.type === "Identifier") {
        return key.name;
      }
      if (key.type === "StringLiteral" || key.type === "Literal") {
        return key.value;
      }
      return null;
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
///////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"node_modules":{"@babel":{"runtime":{"helpers":{"asyncIterator.js":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                       //
// node_modules/meteor/minifyStdJS/node_modules/@babel/runtime/helpers/asyncIterator.js                  //
//                                                                                                       //
///////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                         //
module.useNode();
///////////////////////////////////////////////////////////////////////////////////////////////////////////

}}}}}}}}},{
  "extensions": [
    ".js",
    ".json"
  ]
});


/* Exports */
return {
  require: require,
  eagerModulePaths: [
    "/node_modules/meteor/minifyStdJS/plugin/minify-js.js",
    "/node_modules/meteor/minifyStdJS/plugin/stats.js"
  ]
}});




//# sourceURL=meteor://💻app/packages/minifyStdJS_plugin.js
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
