Package["core-runtime"].queue("compileStaticHtmlBatch",function () {/* Imports */
var ECMAScript = Package.ecmascript.ECMAScript;
var TemplatingTools = Package['static-html-tools'].TemplatingTools;
var CachingCompiler = Package['caching-compiler'].CachingCompiler;
var MultiFileCachingCompiler = Package['caching-compiler'].MultiFileCachingCompiler;
var meteorInstall = Package.modules.meteorInstall;
var Promise = Package.promise.Promise;

var require = meteorInstall({"node_modules":{"meteor":{"compileStaticHtmlBatch":{"static-html.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                 //
// packages/compileStaticHtmlBatch/static-html.js                                                                  //
//                                                                                                                 //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                   //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let CachingHtmlCompiler, scanHtmlForTags, throwCompileError;
    module.link("meteor/static-html-tools", {
      CachingHtmlCompiler(v) {
        CachingHtmlCompiler = v;
      },
      scanHtmlForTags(v) {
        scanHtmlForTags = v;
      },
      throwCompileError(v) {
        throwCompileError = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Plugin.registerCompiler({
      extensions: ['html'],
      archMatching: 'web',
      isTemplate: true
    }, () => new CachingHtmlCompiler("static-html", scanHtmlForTags, compileTagsToStaticHtml));

    // Same API as TutorialTools.compileTagsWithSpacebars, but instead of compiling
    // with Spacebars, it just returns static HTML
    function compileTagsToStaticHtml(tags) {
      const handler = new StaticHtmlTagHandler();
      tags.forEach(tag => {
        handler.addTagToResults(tag);
      });
      return handler.getResults();
    }
    const isEmpty = obj => [Object, Array].includes((obj || {}).constructor) && !Object.entries(obj || {}).length;
    class StaticHtmlTagHandler {
      constructor() {
        this.results = {
          head: '',
          body: '',
          js: '',
          bodyAttrs: {}
        };
      }
      getResults() {
        return this.results;
      }
      addTagToResults(tag) {
        this.tag = tag;

        // do we have 1 or more attributes?
        const hasAttribs = !isEmpty(this.tag.attribs);
        if (this.tag.tagName === "head") {
          if (hasAttribs) {
            this.throwCompileError("Attributes on <head> not supported");
          }
          this.results.head += this.tag.contents;
          return;
        }

        // <body> or <template>

        try {
          if (this.tag.tagName === "body") {
            this.addBodyAttrs(this.tag.attribs);

            // We may be one of many `<body>` tags.
            this.results.body += this.tag.contents;
          } else {
            this.throwCompileError("Expected <head> or <body> tag", this.tag.tagStartIndex);
          }
        } catch (e) {
          if (e.scanner) {
            // The error came from Spacebars
            this.throwCompileError(e.message, this.tag.contentsStartIndex + e.offset);
          } else {
            throw e;
          }
        }
      }
      addBodyAttrs(attrs) {
        Object.keys(attrs).forEach(attr => {
          const val = attrs[attr];

          // This check is for conflicting body attributes in the same file;
          // we check across multiple files in caching-html-compiler using the
          // attributes on results.bodyAttrs
          if (this.results.bodyAttrs.hasOwnProperty(attr) && this.results.bodyAttrs[attr] !== val) {
            this.throwCompileError("<body> declarations have conflicting values for the '".concat(attr, "' attribute."));
          }
          this.results.bodyAttrs[attr] = val;
        });
      }
      throwCompileError(message, overrideIndex) {
        throwCompileError(this.tag, message, overrideIndex);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}}}},{
  "extensions": [
    ".js",
    ".json"
  ]
});


/* Exports */
return {
  require: require,
  eagerModulePaths: [
    "/node_modules/meteor/compileStaticHtmlBatch/static-html.js"
  ]
}});




//# sourceURL=meteor://💻app/packages/compileStaticHtmlBatch_plugin.js
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
