Package["core-runtime"].queue("static-html-tools",function () {/* Imports */
var Meteor = Package.meteor.Meteor;
var global = Package.meteor.global;
var meteorEnv = Package.meteor.meteorEnv;
var EmitterPromise = Package.meteor.EmitterPromise;
var ECMAScript = Package.ecmascript.ECMAScript;
var CachingCompiler = Package['caching-compiler'].CachingCompiler;
var MultiFileCachingCompiler = Package['caching-compiler'].MultiFileCachingCompiler;
var meteorInstall = Package.modules.meteorInstall;
var Promise = Package.promise.Promise;

/* Package-scope variables */
var TemplatingTools;

var require = meteorInstall({"node_modules":{"meteor":{"static-html-tools":{"templating-tools.js":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/static-html-tools/templating-tools.js                                                                    //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./throw-compile-error", {
      throwCompileError: "throwCompileError",
      CompileError: "CompileError"
    }, 0);
    module.link("./html-scanner", {
      scanHtmlForTags: "scanHtmlForTags"
    }, 1);
    module.link("./caching-html-compiler", {
      CachingHtmlCompiler: "CachingHtmlCompiler"
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"caching-html-compiler.js":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/static-html-tools/caching-html-compiler.js                                                               //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      CachingHtmlCompiler: () => CachingHtmlCompiler
    });
    let CompileError;
    module.link("./throw-compile-error", {
      CompileError(v) {
        CompileError = v;
      }
    }, 0);
    let isEmpty;
    module.link("lodash.isempty", {
      default(v) {
        isEmpty = v;
      }
    }, 1);
    let CachingCompiler;
    module.link("meteor/caching-compiler", {
      CachingCompiler(v) {
        CachingCompiler = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const path = Plugin.path;

    // The CompileResult type for this CachingCompiler is the return value of
    // htmlScanner.scan: a {js, head, body, bodyAttrs} object.
    class CachingHtmlCompiler extends CachingCompiler {
      /**
       * Constructor for CachingHtmlCompiler
       * @param  {String} name The name of the compiler, printed in errors -
       * should probably always be the same as the name of the build
       * plugin/package
       * @param  {Function} tagScannerFunc Transforms a template file (commonly
       * .html) into an array of Tags
       * @param  {Function} tagHandlerFunc Transforms an array of tags into a
       * results object with js, body, head, and bodyAttrs properties
       */
      constructor(name, tagScannerFunc, tagHandlerFunc) {
        super({
          compilerName: name,
          defaultCacheSize: 1024 * 1024 * 10
        });
        this._bodyAttrInfo = null;
        this.tagScannerFunc = tagScannerFunc;
        this.tagHandlerFunc = tagHandlerFunc;
      }

      // Implements method from CachingCompilerBase
      // eslint-disable-next-line class-methods-use-this
      compileResultSize(compileResult) {
        const lengthOrZero = field => field ? field.length : 0;
        const headSize = lengthOrZero(compileResult.head);
        const bodySize = lengthOrZero(compileResult.body);
        const jsSize = lengthOrZero(compileResult.js);
        return headSize + bodySize + jsSize;
      }

      // Overrides method from CachingCompiler
      processFilesForTarget(inputFiles) {
        this._bodyAttrInfo = {};
        return super.processFilesForTarget(inputFiles);
      }

      // Implements method from CachingCompilerBase
      // eslint-disable-next-line class-methods-use-this
      getCacheKey(inputFile) {
        // Note: the path is only used for errors, so it doesn't have to be part
        // of the cache key.
        return [inputFile.getArch(), inputFile.getSourceHash(), inputFile.hmrAvailable && inputFile.hmrAvailable()];
      }

      // Implements method from CachingCompiler
      compileOneFile(inputFile) {
        const contents = inputFile.getContentsAsString();
        const inputPath = inputFile.getPathInPackage();
        try {
          const tags = this.tagScannerFunc({
            sourceName: inputPath,
            contents,
            tagNames: ['body', 'head', 'template']
          });
          return this.tagHandlerFunc(tags, inputFile.hmrAvailable && inputFile.hmrAvailable());
        } catch (e) {
          if (e instanceof CompileError) {
            inputFile.error({
              message: e.message,
              line: e.line
            });
            return null;
          }
          throw e;
        }
      }

      // Implements method from CachingCompilerBase
      addCompileResult(inputFile, compileResult) {
        let allJavaScript = '';
        if (compileResult.head) {
          inputFile.addHtml({
            section: 'head',
            data: compileResult.head
          });
        }
        if (compileResult.body) {
          inputFile.addHtml({
            section: 'body',
            data: compileResult.body
          });
        }
        if (compileResult.js) {
          allJavaScript += compileResult.js;
        }
        if (!isEmpty(compileResult.bodyAttrs)) {
          Object.keys(compileResult.bodyAttrs).forEach(attr => {
            const value = compileResult.bodyAttrs[attr];
            if (Object.prototype.hasOwnProperty.call(this._bodyAttrInfo, attr) && this._bodyAttrInfo[attr].value !== value) {
              // two conflicting attributes on <body> tags in two different template
              // files
              inputFile.error({
                message: "".concat("<body> declarations have conflicting values for the '".concat(attr, "' ") + 'attribute in the following files: ').concat(this._bodyAttrInfo[attr].inputFile.getPathInPackage(), ", ").concat(inputFile.getPathInPackage())
              });
            } else {
              this._bodyAttrInfo[attr] = {
                inputFile,
                value
              };
            }
          });

          // Add JavaScript code to set attributes on body
          allJavaScript += "Meteor.startup(function() {\n  var attrs = ".concat(JSON.stringify(compileResult.bodyAttrs), ";\n  for (var prop in attrs) {\n    document.body.setAttribute(prop, attrs[prop]);\n  }\n});\n");
        }
        if (allJavaScript) {
          const filePath = inputFile.getPathInPackage();
          // XXX this path manipulation may be unnecessarily complex
          let pathPart = path.dirname(filePath);
          if (pathPart === '.') pathPart = '';
          if (pathPart.length && pathPart !== path.sep) pathPart += path.sep;
          const ext = path.extname(filePath);
          const basename = path.basename(filePath, ext);

          // XXX generate a source map

          inputFile.addJavaScript({
            path: path.join(pathPart, "template.".concat(basename, ".js")),
            data: allJavaScript
          });
        }
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"html-scanner.js":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/static-html-tools/html-scanner.js                                                                        //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      scanHtmlForTags: () => scanHtmlForTags
    });
    let CompileError;
    module.link("./throw-compile-error", {
      CompileError(v) {
        CompileError = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    function scanHtmlForTags(options) {
      const scan = new HtmlScan(options);
      return scan.getTags();
    }
    /**
     * Scan an HTML file for top-level tags and extract their contents. Pass them to
     * a tag handler (an object with a handleTag method)
     *
     * This is a primitive, regex-based scanner.  It scans
     * top-level tags, which are allowed to have attributes,
     * and ignores top-level HTML comments.
     */
    class HtmlScan {
      /**
       * Initialize and run a scan of a single file
       * @param  {String} sourceName The filename, used in errors only
       * @param  {String} contents   The contents of the file
       * @param  {String[]} tagNames An array of tag names that are accepted at the
       * top level. If any other tag is encountered, an error is thrown.
       */
      constructor(_ref) {
        let {
          sourceName,
          contents,
          tagNames
        } = _ref;
        this.sourceName = sourceName;
        this.contents = contents;
        this.tagNames = tagNames;
        this.rest = contents;
        this.index = 0;
        this.tags = [];
        const tagNameRegex = this.tagNames.join("|");
        const openTagRegex = new RegExp("^((<(".concat(tagNameRegex, ")\\b)|(<!--)|(<!DOCTYPE|{{!)|$)"), "i");
        while (this.rest) {
          // skip whitespace first (for better line numbers)
          this.advance(this.rest.match(/^\s*/)[0].length);
          const match = openTagRegex.exec(this.rest);
          if (!match) {
            this.throwCompileError("Expected one of: <".concat(this.tagNames.join('>, <'), ">"));
          }
          const matchToken = match[1];
          const matchTokenTagName = match[3];
          const matchTokenComment = match[4];
          const matchTokenUnsupported = match[5];
          const tagStartIndex = this.index;
          this.advance(match.index + match[0].length);
          if (!matchToken) {
            break; // matched $ (end of file)
          }
          if (matchTokenComment === '<!--') {
            // top-level HTML comment
            const commentEnd = /--\s*>/.exec(this.rest);
            if (!commentEnd) this.throwCompileError("unclosed HTML comment in template file");
            this.advance(commentEnd.index + commentEnd[0].length);
            continue;
          }
          if (matchTokenUnsupported) {
            switch (matchTokenUnsupported.toLowerCase()) {
              case '<!doctype':
                this.throwCompileError("Can't set DOCTYPE here.  (Meteor sets <!DOCTYPE html> for you)");
              case '{{!':
                this.throwCompileError("Can't use '{{! }}' outside a template.  Use '<!-- -->'.");
            }
            this.throwCompileError();
          }

          // otherwise, a <tag>
          const tagName = matchTokenTagName.toLowerCase();
          const tagAttribs = {}; // bare name -> value dict
          const tagPartRegex = /^\s*((([a-zA-Z0-9:_-]+)\s*=\s*(["'])(.*?)\4)|(>))/;

          // read attributes
          let attr;
          while (attr = tagPartRegex.exec(this.rest)) {
            const attrToken = attr[1];
            const attrKey = attr[3];
            let attrValue = attr[5];
            this.advance(attr.index + attr[0].length);
            if (attrToken === '>') {
              break;
            }

            // XXX we don't HTML unescape the attribute value
            // (e.g. to allow "abcd&quot;efg") or protect against
            // collisions with methods of tagAttribs (e.g. for
            // a property named toString)
            attrValue = attrValue.match(/^\s*([\s\S]*?)\s*$/)[1]; // trim
            tagAttribs[attrKey] = attrValue;
          }
          if (!attr) {
            // didn't end on '>'
            this.throwCompileError("Parse error in tag");
          }

          // find </tag>
          const end = new RegExp('</' + tagName + '\\s*>', 'i').exec(this.rest);
          if (!end) {
            this.throwCompileError("unclosed <" + tagName + ">");
          }
          const tagContents = this.rest.slice(0, end.index);
          const contentsStartIndex = this.index;

          // trim the tag contents.
          // this is a courtesy and is also relied on by some unit tests.
          var m = tagContents.match(/^([ \t\r\n]*)([\s\S]*?)[ \t\r\n]*$/);
          const trimmedContentsStartIndex = contentsStartIndex + m[1].length;
          const trimmedTagContents = m[2];
          const tag = {
            tagName: tagName,
            attribs: tagAttribs,
            contents: trimmedTagContents,
            contentsStartIndex: trimmedContentsStartIndex,
            tagStartIndex: tagStartIndex,
            fileContents: this.contents,
            sourceName: this.sourceName
          };

          // save the tag
          this.tags.push(tag);

          // advance afterwards, so that line numbers in errors are correct
          this.advance(end.index + end[0].length);
        }
      }

      /**
       * Advance the parser
       * @param  {Number} amount The amount of characters to advance
       */
      advance(amount) {
        this.rest = this.rest.substring(amount);
        this.index += amount;
      }
      throwCompileError(msg, overrideIndex) {
        const finalIndex = typeof overrideIndex === 'number' ? overrideIndex : this.index;
        const err = new CompileError();
        err.message = msg || "bad formatting in template file";
        err.file = this.sourceName;
        err.line = this.contents.substring(0, finalIndex).split('\n').length;
        throw err;
      }
      throwBodyAttrsError(msg) {
        this.parseError(msg);
      }
      getTags() {
        return this.tags;
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"throw-compile-error.js":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// packages/static-html-tools/throw-compile-error.js                                                                 //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
module.export({
  CompileError: () => CompileError,
  throwCompileError: () => throwCompileError
});
class CompileError {}
function throwCompileError(tag, message, overrideIndex) {
  const finalIndex = typeof overrideIndex === 'number' ? overrideIndex : tag.tagStartIndex;
  const err = new CompileError();
  err.message = message || "bad formatting in template file";
  err.file = tag.sourceName;
  err.line = tag.fileContents.substring(0, finalIndex).split('\n').length;
  throw err;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"node_modules":{"lodash.isempty":{"package.json":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// node_modules/meteor/static-html-tools/node_modules/lodash.isempty/package.json                                    //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
module.exports = {
  "name": "lodash.isempty",
  "version": "4.4.0"
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.js":function module(require,exports,module){

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                   //
// node_modules/meteor/static-html-tools/node_modules/lodash.isempty/index.js                                        //
//                                                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                     //
module.useNode();
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}}}}}},{
  "extensions": [
    ".js",
    ".json"
  ]
});


/* Exports */
return {
  export: function () { return {
      TemplatingTools: TemplatingTools
    };},
  require: require,
  eagerModulePaths: [
    "/node_modules/meteor/static-html-tools/templating-tools.js"
  ],
  mainModulePath: "/node_modules/meteor/static-html-tools/templating-tools.js"
}});




//# sourceURL=meteor://💻app/packages/static-html-tools.js
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
